/*-----------------------------------------------------------------------------------------------------------------
*  AUTHOR: TIM RIST & MARCEL THIEL 
*
*
*
*
*
*
*
*
*
*
*
------------------------------------------------------------------------------------------------------------------*/



// Libarys

#include "Adafruit_VL53L0X.h"     

#include <Wire.h>
//#include <VL6180X.h>

#include "Ardumotor.h"
#include "Config.h" 

Motor Motor_Disc(DIRB, PWMB);
Motor Motor_Linear(DIRA, PWMA);

Adafruit_VL53L0X Sensor_Linear = Adafruit_VL53L0X();

int Linear_Distance_Offset = 0;
int Measured_Distance = 0;
volatile long Encoder_Counts = 0;

unsigned long lastPIDUpdate = 0;

bool flag;
long flagcounter = 0;


uint16_t distances[3];





int PID(float Reference, int currentValue, float VM0, float Kp, float Ti, float Td, float Ts, int &direction) {
  // Statische Variablen für persistente Werte zwischen Funktionsaufrufen
  static float u_k_1 = 0;  // Vorheriger Stellwert (Reglerausgang)
  static float e_k_1 = 0;  // Vorheriger Fehler

  // Fehlerberechnung
  float ek = Reference - currentValue;  // Aktueller Fehler

  // PID-Berechnung
  float up = Kp * ek;                               // Proportionaler Anteil
  float ui = u_k_1 + (Kp / Ti) * ek * Ts;           // Integrierender Anteil
  float ud = Kp * Td * ((ek - e_k_1) / Ts);         // Differenzierender Anteil

  // Begrenzung des Integralanteils (Anti-Windup)
  float integral_max = 11.9;  // Maximale Begrenzung des Integrals  -16
  float integral_min = -11.9; // Minimale Begrenzung des Integrals
  if (ui > integral_max) ui = integral_max;
  if (ui < integral_min) ui = integral_min;

  // Gesamter PID-Ausgang
  float uk = up + ui + ud;

  // Begrenzung des Stellwerts (Reglerausgang)
  if (uk > 255) {
    uk = 255;
    ui = u_k_1;  // Freeze des Integrals bei oberer Begrenzung
  }
  if (uk < -255) {
    uk = -255;
    ui = u_k_1;  // Freeze des Integrals bei unterer Begrenzung
  }

  // Richtung basierend auf dem Ausgangswert
  if (uk >= 0) {
    direction = FORWARD;  // Vorwärtsbewegung
  } else {
    direction = REVERSE;  // Rückwärtsbewegung
  }

  // Aktuelle Werte für den nächsten Schritt speichern
  u_k_1 = ui;  // Integralterm speichern
  e_k_1 = ek;  // Aktuellen Fehler speichern


  // Rückgabe des absoluten PWM-Werts (0–255)
  return abs(uk);
}


void Zeroing()
{
  while(digitalRead(LIMITSWITCH) == HIGH)
  {
    Motor_Linear.drive(85,REVERSE);
  }
  Motor_Linear.stop();
 

  for (int i = 0; i < 3; i++)
  {
   while (!Sensor_Linear.isRangeComplete()) {}
    
   distances[i] = Sensor_Linear.readRangeResult();
  


    Linear_Distance_Offset = (distances[0] + distances[1] + distances[2]) / 3;

  }
  delay(3000);
  Motor_Disc.drive(100, FORWARD);
  delay(6);
  Motor_Disc.drive(33, FORWARD);

}


void encoderISR() 
{
  Encoder_Counts++;  // Zähler erhöhen
  if((Encoder_Counts % 1200) == 0){
    flag = true;
  }
}


void setup() {
  Motor_Disc.setup();
  Motor_Linear.setup();
  pinMode(LIMITSWITCH, INPUT);

  Serial.begin(115200);
  // wait until serial port opens for native USB devices
  while (! Serial) {
    delay(1);
  }


 if (!Sensor_Linear.begin()) {
    Serial.println(F("Failed to boot VL53L0X"));
    while(1){}
    
  }
 Sensor_Linear.setMeasurementTimingBudgetMicroSeconds(50000);  
 Sensor_Linear.startRangeContinuous();


  attachInterrupt(digitalPinToInterrupt(ENCODER_A), encoderISR, RISING);
  attachInterrupt(digitalPinToInterrupt(ENCODER_B), encoderISR, RISING);


 Zeroing();
}

void loop() {

 
  long pmillis = millis();
  for (int i = 0; i < 3; i++) {
    // Warte, bis eine Messung abgeschlossen ist
    while (!Sensor_Linear.isRangeComplete()) {
      // Warten bis Messung abgeschlossen
    }

    // Lese den Messwert
    distances[i] = Sensor_Linear.readRangeResult();
  

    // Gib die Messung aus
    //Serial.print(i + 1);
   // Serial.print(": ");
    //Serial.print(distances[i]);
    //Serial.println(" mm");


  }

  
   Measured_Distance = (distances[0] + distances[1] + distances[2]) / 3;
   Measured_Distance = Measured_Distance - Linear_Distance_Offset;
  // Serial.println(Measured_Distance);




  
  // Überprüfe den Rest der Division, um abwechselnd zwischen den Aktionen zu wechseln
  if (flag == true) {
    flag = false;
    flagcounter++;
    if (flagcounter % 2 == 0) {
      setpoint = 150;

      //setpoint =    // Aktion für Vielfache von 604, 1812, 3024, ...
    } else {
      setpoint = 224;  // Aktion für Vielfache von 1208, 2424, 3636, ...


    }
  }



 if (millis() - lastPIDUpdate >= PIDInterval) {
    pwmValue = PID(setpoint, Measured_Distance, VM0, Kp, Ti, Td, Ts, direction);
    lastPIDUpdate = millis();
    pwmValue = constrain(pwmValue, 65, 130);    // Map PWM to 50–120 range
    Motor_Linear.drive(pwmValue, direction);    // Drive the motor using the calculated PWM value and direction


  }



/*
  Serial.print("Encoder Count: ");
  Serial.println(Encoder_Counts);

  
*/
  



}
