#ifndef MOTORCONFIG_H
#define MOTORCONFIG_H

// Clockwise and counter-clockwise definitions.
#define FORWARD  0
#define REVERSE 1

// Motor definitions
#define MOTOR_A 0
#define MOTOR_B 1

// Pin Assignments // Default pins
#define DIRA 2    // Direction control for motor A
#define PWMA 3    // PWM control (speed) for motor A
#define DIRB 4    // Direction control for motor B
#define PWMB 11   // PWM control (speed) for motor B

#define LIMITSWITCH 17

#define ENCODER_A 15
#define ENCODER_B 14


#define LINEARMAX 260
#define LINEARMIN 0




//PID Definitions:
float Kp = 3.5;      // Proportional gain   // 3.5 - 0.55 -0.1 
float Ti = 0.55;      // Integral time
float Td = 0.1;      // Derivative time
float Ts = 0.15;     // Sampling time (in seconds)  --  posibility that interrupts lead to a higher time needed for a complete average distance measurement
float VM0 = 0;       // Offset for operating point

unsigned long PIDInterval = Ts*1000;

// Variables
float setpoint = 150;  // Desired position in mm      //214.5 226
int direction = 0;       // Motor direction: 1 = FORWARD, 0 = REVERSE
int pwmValue = 0;        // PWM signal for motor control


#endif // MOTORCONFIG_H
