
#ifndef ARDMOTOR_H
#define ARDMOTOR_H

#include <Arduino.h> // Include Arduino functions

class Motor {
  public:
    // Constructor that takes direction and PWM pins
    Motor(byte dirPin, byte pwmPin);

    // Setup the motor pins
    void setup();

    // Stop the motor (set PWM to 0)
    void stop();

    // Drive the motor with PWM value and direction
    void drive(byte pwm, byte dir);

  private:
    byte DIR_Pin;  // Pin for motor direction
    byte PWM_Pin;  // Pin for PWM control (speed)
};

#endif // ARDMOTOR_H
