#include <Arduino.h> 
#include "Ardumotor.h"


// Initialize the pins for PWM and direction

Motor::Motor(byte dirPin, byte pwmPin) {
    DIR_Pin = dirPin;
    PWM_Pin = pwmPin;
}

void Motor::setup() {
    pinMode(PWM_Pin, OUTPUT);  // Set the PWM pin as output
    pinMode(DIR_Pin, OUTPUT);  // Set the direction pin as output
    digitalWrite(PWM_Pin, LOW); // Set PWM pin to LOW (motor off initially)
    digitalWrite(DIR_Pin, LOW); // Set direction pin to LOW (motor stopped initially)
}

// Stop the motor (set PWM to 0)
void Motor::stop() {
    analogWrite(PWM_Pin, 0);  // Set PWM output to 0 to stop the motor
}

// Control the motor (set PWM and direction)
void Motor::drive(byte pwm, byte dir) {
    analogWrite(PWM_Pin, pwm);  // Set the PWM output
    digitalWrite(DIR_Pin, dir); // Set the direction (HIGH or LOW)
}
